#include <iostream>
#include <set>
#include <map>
#define _USE_MATH_DEFINES
#include <cmath>
#include <algorithm>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <ctime>
#include <random>

using namespace std;

using ll = long long;
using ld = long double;
using vll = vector<ll>;
using vvll = vector<vll>;
using pll = pair<ll, ll>;
using vpll = vector<pll>;

ll INF = 1e18;
ld EPS = 1e-9;

ll MOD = 1e9 + 7;
ll P = 239;
ll B = 350;

minstd_rand generator;

int main() {
#ifdef LOCAL
    freopen("inp.txt", "r", stdin);
    freopen("out.txt", "w", stdout);

    clock_t timer = clock();
#else
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    cout.precision(64);
    cout << fixed;
#endif

    ll t;
    cin >> t;

    vector<ll> p;
    for (ll i = 1; i < 1000; i++) {
        string s = to_string(i);
        string s1 = s;
        reverse(s1.begin(), s1.end());

        if (s1 == s)
            p.push_back(i);
    }

    vector<vector<ll>> dp(p.size() + 1, vector<ll>(1000, INF));
    for (ll i = 0; i < p.size(); i++)
        dp[i][0] = 0;

    for (ll i = 1; i <= p.size(); i++) {
        for (ll j = 1; j < 1000; j++) {
            dp[i][j] = dp[i-1][j];
            if (j-p[i-1] >= 0) dp[i][j] = min(dp[i][j], dp[i-1][j-p[i-1]] + 1);
        }
    }

    while (t--) {
        ll n;
        cin >> n;

        cout << dp[p.size()][n] << "\n";
    }

#ifdef LOCAL
    cout << "\nExecution time: " << (ld)(clock() - timer) / CLOCKS_PER_SEC;
#endif
}
